/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.relocations.redis.clients.jedis;

import java.time.Duration;
import java.util.Set;
import net.impactdev.impactor.relocations.org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import net.impactdev.impactor.relocations.redis.clients.jedis.ClusterCommandArguments;
import net.impactdev.impactor.relocations.redis.clients.jedis.ClusterCommandObjects;
import net.impactdev.impactor.relocations.redis.clients.jedis.CommandArguments;
import net.impactdev.impactor.relocations.redis.clients.jedis.Connection;
import net.impactdev.impactor.relocations.redis.clients.jedis.HostAndPort;
import net.impactdev.impactor.relocations.redis.clients.jedis.JedisClientConfig;
import net.impactdev.impactor.relocations.redis.clients.jedis.MultiNodePipelineBase;
import net.impactdev.impactor.relocations.redis.clients.jedis.RedisProtocol;
import net.impactdev.impactor.relocations.redis.clients.jedis.providers.ClusterConnectionProvider;
import net.impactdev.impactor.relocations.redis.clients.jedis.util.IOUtils;

public class ClusterPipeline
extends MultiNodePipelineBase {
    private final ClusterConnectionProvider provider;
    private AutoCloseable closeable = null;

    public ClusterPipeline(Set<HostAndPort> clusterNodes, JedisClientConfig clientConfig) {
        this(new ClusterConnectionProvider(clusterNodes, clientConfig), ClusterPipeline.createClusterCommandObjects(clientConfig.getRedisProtocol()));
        this.closeable = this.provider;
    }

    public ClusterPipeline(Set<HostAndPort> clusterNodes, JedisClientConfig clientConfig, GenericObjectPoolConfig<Connection> poolConfig) {
        this(new ClusterConnectionProvider(clusterNodes, clientConfig, poolConfig), ClusterPipeline.createClusterCommandObjects(clientConfig.getRedisProtocol()));
        this.closeable = this.provider;
    }

    public ClusterPipeline(Set<HostAndPort> clusterNodes, JedisClientConfig clientConfig, GenericObjectPoolConfig<Connection> poolConfig, Duration topologyRefreshPeriod) {
        this(new ClusterConnectionProvider(clusterNodes, clientConfig, poolConfig, topologyRefreshPeriod), ClusterPipeline.createClusterCommandObjects(clientConfig.getRedisProtocol()));
        this.closeable = this.provider;
    }

    public ClusterPipeline(ClusterConnectionProvider provider) {
        this(provider, new ClusterCommandObjects());
    }

    public ClusterPipeline(ClusterConnectionProvider provider, ClusterCommandObjects commandObjects) {
        super(commandObjects);
        this.provider = provider;
    }

    private static ClusterCommandObjects createClusterCommandObjects(RedisProtocol protocol) {
        ClusterCommandObjects cco = new ClusterCommandObjects();
        if (protocol == RedisProtocol.RESP3) {
            cco.setProtocol(protocol);
        }
        return cco;
    }

    @Override
    public void close() {
        try {
            super.close();
        }
        finally {
            IOUtils.closeQuietly(this.closeable);
        }
    }

    @Override
    protected HostAndPort getNodeKey(CommandArguments args2) {
        return this.provider.getNode(((ClusterCommandArguments)args2).getCommandHashSlot());
    }

    @Override
    protected Connection getConnection(HostAndPort nodeKey) {
        return this.provider.getConnection(nodeKey);
    }

    public void prepareGraphCommands() {
        super.prepareGraphCommands(this.provider);
    }
}

